Bitmap = copy_table(Shape)

function Bitmap:init(def, view)
    Shape.init(self, def, view, true)

    if def.bitmap then
        self.bitmap = gfx_load_bitmap(def.bitmap)
        self.sprite = def.sprite or "main"
        self.w, self.h, self.cx, self.cy = gfx_sprite_params(self.bitmap, self.sprite)
    end
    
    self.w = def.w or self.w
    self.h = def.h or self.h
    self.cx = def.cx or self.cx
    self.cy = def.cy or self.cy
    self.scale_x = def.scale_x or def.scale or 1
    self.scale_y = def.scale_y or def.scale or 1
    self.color = def.color

    if self:area_needed() then
        self:create_area(def.area)
    end
    
    self.alpha = def.alpha or 1
end


function Bitmap:destroy()
    if self.bitmap then
        gfx_release_bitmap(self.bitmap)
    end
end


function Bitmap:render()
    if self.bitmap then
        gfx_render_sprite(self.bitmap, self.sprite, self.x, self.y, self.alpha, self.angle, self.scale_x, self.scale_y, self.color)
    end
end
